@extends('layouts.admin')

@section('title', 'Bölge Düzenle')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.bolge-tanimlamalari.index') }}">Bölge Tanımlamaları</a>
                </div>
                <h2 class="page-title">
                    @if($tur === 'il') İl
                    @elseif($tur === 'ilce') İlçe
                    @elseif($tur === 'belde') Belde/Semt
                    @endif
                    Düzenle
                </h2>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>{{ session('error') }}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Bölge Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('admin.bolge-tanimlamalari.update', $id) }}">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="tur" value="{{ $tur }}">

                            <div class="mb-3">
                                <label class="form-label required">
                                    @if($tur === 'il') İl Adı
                                    @elseif($tur === 'ilce') İlçe Adı
                                    @elseif($tur === 'belde') Belde/Semt Adı
                                    @endif
                                </label>
                                <input type="text" class="form-control @error('ad') is-invalid @enderror" 
                                       name="ad" 
                                       value="{{ old('ad', $bolge->ad) }}" 
                                       required>
                                @error('ad')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.bolge-tanimlamalari.index') }}" class="btn">
                                    İptal
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" />
                                        <path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" />
                                        <path d="M16 5l3 3" />
                                    </svg>
                                    Güncelle
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
