@extends('layouts.admin')

@section('title', 'Yeni Bölge Ekle')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.bolge-tanimlamalari.index') }}">Bölge Tanımlamaları</a>
                </div>
                <h2 class="page-title">
                    Yeni 
                    @if($tur === 'il') İl
                    @elseif($tur === 'ilce') İlçe
                    @elseif($tur === 'belde') Belde/Semt
                    @endif
                    Ekle
                </h2>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>{{ session('error') }}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Bölge Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('admin.bolge-tanimlamalari.store') }}">
                            @csrf
                            <input type="hidden" name="tur" value="{{ $tur }}">
                            @if($parentId)
                                <input type="hidden" name="parent_id" value="{{ $parentId }}">
                            @endif

                            @if($parentAd)
                                <div class="mb-3">
                                    <label class="form-label">
                                        @if($tur === 'ilce') Bağlı Olduğu İl
                                        @elseif($tur === 'belde') Bağlı Olduğu İlçe
                                        @endif
                                    </label>
                                    <input type="text" class="form-control" value="{{ $parentAd }}" readonly>
                                </div>
                            @endif

                            <div class="mb-3">
                                <label class="form-label required">
                                    @if($tur === 'il') İl Adı
                                    @elseif($tur === 'ilce') İlçe Adı
                                    @elseif($tur === 'belde') Belde/Semt Adı
                                    @endif
                                </label>
                                <input type="text" class="form-control @error('ad') is-invalid @enderror" 
                                       name="ad" 
                                       value="{{ old('ad') }}" 
                                       placeholder="
                                       @if($tur === 'il') Örnek: İstanbul
                                       @elseif($tur === 'ilce') Örnek: Kadıköy
                                       @elseif($tur === 'belde') Örnek: Fenerbahçe
                                       @endif
                                       " 
                                       required>
                                @error('ad')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <div class="form-label">Bilgilendirme</div>
                                <div class="alert alert-info mb-0">
                                    @if($tur === 'il')
                                        <strong>İl</strong> ekledikten sonra bu ilin altına <strong>İlçe</strong> ekleyebilirsiniz.
                                    @elseif($tur === 'ilce')
                                        <strong>İlçe</strong> ekledikten sonra bu ilçenin altına <strong>Belde/Semt</strong> ekleyebilirsiniz.
                                    @elseif($tur === 'belde')
                                        Bu <strong>Belde/Semt</strong>, hiyerarşinin son seviyesidir.
                                    @endif
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <a href="{{ route('admin.bolge-tanimlamalari.index') }}" class="btn">
                                    İptal
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <line x1="12" y1="5" x2="12" y2="19" />
                                        <line x1="5" y1="12" x2="19" y2="12" />
                                    </svg>
                                    Kaydet
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
