# Kan Bankası Bilgi ve SMS Bildirim Sistemi — Laravel Yol Haritası

Bu doküman, sistemin Laravel altyapısıyla kurulumu, çoklu kurum (multi-tenant) desteği, üç portal yapısı, JetSMS entegrasyonu ve tema (`ui-master`) entegrasyonu için ayrıntılı yol haritasını içerir.

## 1. Teknoloji ve Mimari Seçimler
- **Framework:** Laravel 11 (PHP 8.2+)
- **DB:** MySQL 8 (InnoDB, utf8mb4)
- **Önyüz:** `ui-master` teması (Material Dashboard), Blade layout ve component’lara dönüştürülecek.
- **Build:** Vite (Laravel 11 default), asset kopyalama veya import stratejisi.
- **Queue:** `database` veya `redis` driver (SMS dağıtımı için zorunlu öneri: Redis).
- **Auth:** Kullanıcı için OTP (şifresiz), admin/süperadmin için klasik şifreli giriş.
- **Multi-tenant:** Host tabanlı `TenantResolver` middleware.

## 2. Proje Kurulum ve Başlangıç
- Yeni Laravel projesi oluşturun (kök dizin):
  - `laravel new kan_bankasi_sistemi` veya Composer ile.
- `ui-master` klasörü, Laravel projesinde `resources` ve `public` içine uygun şekilde taşınacak:
  - `resources/views/layouts`, `resources/views/pages`
  - `public/assets` (css/js/img/fonts)
- `.env` yapılandırması:
  - DB bağlantısı (`DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`)
  - Queue (`QUEUE_CONNECTION=redis` veya `database`)
  - JetSMS (`JETSMS_USER`, `JETSMS_PASS`, `JETSMS_SENDER`, `JETSMS_TEST_MODE`)

## 3. Domain ve Tenant Resolver
- Middleware: `App\Http\Middleware\TenantResolver`
- Mantık:
  - `host = request->getHost()`
  - Öncelik: `kurumlar.ozel_domain == host` → eşleşirse.
  - Değilse subdomain ilk segment → `slug` çıkar, `kurumlar.slug == slug` kontrol.
  - Ana domain ise varsayılan kurum veya genel landing.
- Resolver çıktısı request context’e konur: `kurum_id`, `kurum_slug`, `aktif_domain`.
- Global scope veya per-request context ile repository/service katmanında filtre.

## 4. Route ve Guard Yapısı
- Kullanıcı portalı (`/`):
  - OTP giriş akışı, profil, ilan verme, ilanlarım, grubumdaki ilanlar, bağış formu.
- Kurum yönetim (`/yonetim`):
  - `auth:admin` guard; kullanıcı/ilan/sms yönetimi.
- Süperadmin (`/superadmin`):
  - `auth:superadmin` guard; kurumlar, global kataloglar, sms politikaları.
- Public ilan detay: `/ilandetay/{ilan_id}` — giriş gerekmez; tenant doğrulaması yapılır.

## 5. Modül ve Katmanlar
- Controllers: `User`, `Admin`, `Superadmin`, `Public`
- Services:
  - `SmsService` (arayüz) → provider: `JetSmsProvider`
  - `OtpService` (rate limit + doğrulama)
  - `TenantService` (resolver yardımcıları)
  - `LinkService` (aktif domain ile detay linki üretimi)
- Repositories: DB erişim soyutlaması (opsiyonel).
- Policies/Middleware: kurumsal veri izolasyonu.

## 6. Veritabanı Migration’ları
- `kurumlar` (id, ad, slug, ana_domain, ozel_domain, aktif_mi, timestamps)
- `kullanicilar` (id, kurum_id, ad_soyad, tc_kimlik_no UNIQUE, telefon UNIQUE, dogum_tarihi, il_id, ilce_id, mahalle_koy, kan_grubu_id, anne_adi, baba_adi, sms_izni, saglik_beyani, kan_verebilirim, aktif_mi, timestamps)
- `yoneticiler` (id, kurum_id nullable, ad_soyad, eposta UNIQUE, kullanici_adi UNIQUE nullable, sifre_hash, rol ENUM[kurum_admin, superadmin], aktif_mi, timestamps)
- `kan_gruplari` (id, ad, aktif_mi)
- `iller` (id, ad)
- `ilceler` (id, il_id, ad)
- `kan_ilanlari` (id, kurum_id, kullanici_id, hastane_adi, tarih, saat, unite_sayisi, irtibat_telefonu, notlar TEXT, kan_grubu_id, il_id, ilce_id, durum ENUM[aktif, iptal, tamamlandi, suresi_doldu], olusturulma_tarihi, timestamps) + indeksler
- `oturum_dogrulama_kodlari` (id, telefon, kod, son_kullanim_tarihi, kullanildi_mi, ip, user_agent, timestamps)
- `kan_bagis_formlari` (id, kurum_id, kan_ilan_id, kullanici_id, bagis_tarihi, bagis_saati, bagislanan_unite_sayisi, notlar, durum nullable, timestamps) + opsiyonel UNIQUE(kan_ilan_id, kullanici_id)
- `sms_ayarlar` (id, kurum_id nullable, saglayici_adi, jetsms_kullanici_adi, jetsms_sifre_enc, jetsms_baslik, test_modu, gunluk_sms_limiti, guncellenme_tarihi, timestamps)
- `sms_sablonlari` (id, kurum_id nullable, kod, baslik, icerik TEXT, aktif_mi, guncellenme_tarihi, timestamps) + UNIQUE(kurum_id, kod)
- `sms_kayitlari` (id, kurum_id, tip, telefon, mesaj, durum, sms_saglayici_mesaj_id, hata_mesaji, olusturulma_tarihi, timestamps)
- `kan_ilan_smsleri` (id, kurum_id, kan_ilan_id, kullanici_id, telefon, sms_durumu, sms_saglayici_mesaj_id, gonderim_tarihi, hata_mesaji, timestamps)

## 7. Seed ve Kataloglar
- `kan_gruplari` seed: A Rh+, A Rh-, B Rh+, B Rh-, AB Rh+, AB Rh-, 0 Rh+, 0 Rh-
- İller/ilçeler: CSV import veya admin panelinden.

## 8. JetSMS Entegrasyonu
- Ortak arayüz: `SmsServiceInterface { send(to, message, options): SmsResult }`
- Provider: `JetSmsProvider`:
  - Env: `JETSMS_USER`, `JETSMS_PASS`, `JETSMS_SENDER`, `JETSMS_TEST_MODE`
  - Mesaj gönderim: tekil ve toplu API endpoint’leri.
  - Başarılı/başarısız yanıtların `sms_kayitlari` ve `kan_ilan_smsleri`’ne işlenmesi.
- Şablon Motoru:
  - Placeholder seti:
    - OTP: `{OTP_KODU}`
    - Kan ilanı: `{AD_SOYAD}`, `{KAN_GRUBU}`, `{TARIH}`, `{SAAT}`, `{UNITE}`, `{HASTANE}`, `{IL}`, `{ILCE}`, `{DETAY_LINKI}`
  - `LinkService` ile `https://{aktif_domain}/ilandetay/{ilan_id}` üretimi.
- Politika:
  - Global vs Kurum Modu: `sms_ayarlar.kurum_id IS NULL` veya `= X` öncelik.
- Queue:
  - Toplu gönderimler için job: `DispatchKanIlanSmsJob` (chunk ve rate limit saygısı).

## 9. OTP Akışı
1) Kullanıcı TC/telefon ile giriş talep eder.
2) Kullanıcıyı bul; kayıt yoksa hata.
3) 6 haneli OTP üret, 5 dk geçerlilik.
4) `oturum_dogrulama_kodlari`’na yaz; rate limit uygula.
5) JetSMS ile OTP mesajını gönder (`giris_otp` şablonu).
6) Kullanıcı OTP’yi girer; geçerliyse oturum aç; kodu `kullanildi_mi=1`.

## 10. Üç Portal Ekranları
- Kullanıcı (`/`):
  - Üye ol, OTP ile giriş, profil, kan ilanı ver, ilanlarım, grubumdaki ilanlar, bağış formu.
- Kurum Admin (`/yonetim`):
  - Kullanıcı yönetimi, kan ilanları, SMS ayarları+şablonları, SMS kayıtları, raporlar.
- SüperAdmin (`/superadmin`):
  - Kurumlar, yönetici hesapları, global kullanıcı/ilanlar, kataloglar, SMS politika/ayarlar, raporlar.
- Public (`/ilandetay/{ilan_id}`):
  - İlan detay; KVKK onay süreçleri UI’da.

## 11. Tema (`ui-master`) Entegrasyonu
- Layout:
  - `resources/views/layouts/app.blade.php`
  - Navbar, sidebar, footer parçaları component’lara bölünür.
- Sayfalar:
  - `resources/views/pages/` altında `dashboard`, `profile`, `tables`, vb. Blade’ler.
- Asset’ler:
  - `public/assets` altına CSS/JS/img/fonts kopyalanır ve layout’ta referans verilir.
  - Alternatif: Vite ile import; gerekirse `vite.config.js` alias.

## 12. Güvenlik ve Rate Limit
- OTP üretim denemesi telefon bazlı rate limit.
- Yanlış OTP denemelerinde geçici blok.
- Admin girişlerinde throttling.
- HTTPS zorunlu.

## 13. Test ve Onay
- Feature test’leri:
  - Kayıt tekillik: TC/telefon ikinci kayıtta hata.
  - OTP akışı ve rate limit senaryoları.
  - Tenant izolasyonu: admin başka kurum verisini göremez.
  - Public ilan detay: doğru host, ilan-kurum eşleşmesi.
  - SMS şablonundan doğru `{DETAY_LINKI}` üretimi.

## 14. Teslim Paketleri
1) Migration ve seed dosyaları
2) TenantResolver middleware
3) Üç portal route/guard
4) SMS servis katmanı + JetSMS provider + şablon motoru
5) Public ilan detay sayfası
6) Admin ekranları: SMS ayarları, şablonları, loglar

## 15. Aşamalı Plan (Fazlar)
- Faz 1: Proje kurulumu, DB şeması, seed, TenantResolver, landing.
- Faz 2: Kullanıcı OTP akışı, profil, ilan verme, public ilan detay.
- Faz 3: Kurum admin paneli (kullanıcı/ilan yönetimi), SMS şablon/ayar.
- Faz 4: JetSMS entegrasyonu, queue ile toplu SMS, loglama.
- Faz 5: Süperadmin modülleri, raporlar, politika anahtarları.
- Faz 6: Güvenlik sertleştirmesi, rate limit, audit-log opsiyonları.
- Faz 7: Sistem testleri, dokümantasyon, dev/prod yayın.

## 16. Yapay Zeka Önerisi
- Geliştirme hızını artırmak için öneri: **GitHub Copilot (GPT-5)**
  - Blade ve Laravel API önerileri, migration/controller scaffold hızlandırma.
  - Kod tamamlama ve refactor desteğiyle süreyi kısaltır.
- Alternatif: **OpenAI API ile RAG dokümantasyon asistanı**
  - Proje dokümanlarını vektörle indeksleyip ekip içi Q&A hızlandırma.

---

### Örnek .env Anahtarları (JetSMS)
```
JETSMS_USER="kullanici"
JETSMS_PASS="sifre"
JETSMS_SENDER="BASLIK"
JETSMS_TEST_MODE=true
```

### Yapılacaklar (Özet)
- Laravel iskeleti ve env kurulumu
- Migration’lar ve seed
- TenantResolver middleware
- Üç portal router/guard
- `ui-master` temayı Blade’e taşı
- JetSMS provider + SmsService arayüzü
- OTP ve SMS şablon motoru
- Public ilan detay ve bağış formu
- Queue ile toplu SMS ve loglama
