<?php

use Illuminate\Support\Str;

if (!function_exists('generate_ilan_link_token')) {
    /**
     * Kan ilanı için benzersiz 5 karakterlik token üretir (büyük-küçük harf + rakam duyarlı)
     * ve 72 saat geçerlilik tarihi belirler
     * 
     * @param int $ilanId
     * @return array ['token' => string, 'gecerlilik_tarihi' => Carbon]
     */
    function generate_ilan_link_token($ilanId)
    {
        // Benzersiz, büyük-küçük harf duyarlı 5 karakterlik token oluştur
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        do {
            $token = '';
            for ($i = 0; $i < 5; $i++) {
                $token .= $characters[random_int(0, strlen($characters) - 1)];
            }
            // Veritabanında benzersiz olup olmadığını kontrol et
            $exists = DB::table('kan_ilanlari')->where('link_token', $token)->exists();
        } while ($exists);
        
        // 72 saat sonrası için geçerlilik tarihi
        $gecerlilikTarihi = now()->addHours(72);
        
        return [
            'token' => $token,
            'gecerlilik_tarihi' => $gecerlilikTarihi
        ];
    }
}

if (!function_exists('update_ilan_link_token')) {
    /**
     * Kan ilanı için link tokenını günceller
     * 
     * @param int $ilanId
     * @return string Token
     */
    function update_ilan_link_token($ilanId)
    {
        $tokenData = generate_ilan_link_token($ilanId);
        
        DB::table('kan_ilanlari')
            ->where('id', $ilanId)
            ->update([
                'link_token' => $tokenData['token'],
                'link_gecerlilik_tarihi' => $tokenData['gecerlilik_tarihi'],
                'updated_at' => now()
            ]);
        
        return $tokenData['token'];
    }
}

if (!function_exists('get_ilan_link_url')) {
    /**
     * Kan ilanı için tam link URL'i döndürür
     * 
     * @param int $ilanId
     * @param string|null $token Token yoksa yeniden üret
     * @return string
     */
    function get_ilan_link_url($ilanId, $token = null)
    {
        if (!$token) {
            $ilan = DB::table('kan_ilanlari')->find($ilanId);
            $token = $ilan->link_token ?? update_ilan_link_token($ilanId);
        }
        
        return route('ilan.link', ['token' => $token]);
    }
}
