<?php

namespace App\Services\Sms;

/**
 * Interface SmsGonderimInterface
 * Tüm SMS sağlayıcılarının uygulaması gereken temel metotları tanımlar.
 */
interface SmsGonderimInterface
{
    /**
     * Belirtilen numaralara SMS gönderir.
     *
     * @param array $ayarlar API ayarları (kullanıcı adı, şifre vb.)
     * @param string $baslik Gönderen başlığı (Originator)
     * @param string $mesaj Gönderilecek mesaj içeriği
     * @param array|string $numaralar Alıcı telefon numaraları (tekil veya dizi)
     * @return array Gönderim sonucunu içeren bir dizi. ['status' => 'success|error', 'message' => '...', 'data' => ...]
     */
    public function gonder(array $ayarlar, string $baslik, string $mesaj, $numaralar): array;
}
