<?php

namespace App\Services\Sms;

/**
 * SMS servis sağlayıcısı factory sınıfı
 * Seçilen operatöre göre doğru SMS sağlayıcısını döndürür
 */
class SmsFactory
{
    /**
     * Belirtilen sağlayıcı için SMS servisini oluşturur
     *
     * @param string $saglayici 'netgsm' veya 'jetsms'
     * @return SmsGonderimInterface
     * @throws \Exception
     */
    public static function create(string $saglayici): SmsGonderimInterface
    {
        return match(strtolower($saglayici)) {
            'netgsm' => new NetgsmSaglayici(),
            'jetsms' => new JetSmsSaglayici(),
            default => throw new \Exception("Desteklenmeyen SMS sağlayıcısı: {$saglayici}"),
        };
    }
}
