<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class AdminKullanici extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'admin_kullanicilar';

    protected $fillable = [
        'kurum_id',
        'ad',
        'soyad',
        'kullanici_adi',
        'email',
        'password',
        'rol',
        'aktif',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'password' => 'hashed',
            'aktif' => 'boolean',
        ];
    }

    // Ad ve soyad birleşik accessor
    public function getNameAttribute()
    {
        return trim($this->ad . ' ' . $this->soyad);
    }
}
