<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class KurumCozumleyici
{
    public function handle(Request $request, Closure $next)
    {
        $host = $request->getHost();
        $aktifDomain = $host;
        $kurumId = null;
        $kurumSlug = null;

        // Desteklenen desenler:
        // 1) slug.siteadi.com
        // 2) kurum.kan.siteadi.com  -> 'kurum' kısmı kurum slug'ı
        // 3) Özel domain eşleşmesi (ozel_domain)

        $kurumAdi = null;
        $kayit = null;

        $parcalar = explode('.', $host);
        if (count($parcalar) >= 2) {
            // subdomain var (demo.localhost veya kurum.kan.siteadi.com)
            $sub = $parcalar[0];
            $ikinci = $parcalar[1];
            $third = $parcalar[2] ?? null;

            // kurum.kan.siteadi.com deseni: ikinci parça 'kan' ise sub kurum slug kabul edilir
            if ($ikinci === 'kan') {
                $kayit = DB::table('kurumlar')->where('slug', $sub)->where('aktif_mi', true)->first();
                if ($kayit) {
                    $kurumId = $kayit->id;
                    $kurumSlug = $kayit->slug;
                    $kurumAdi = $kayit->ad;
                }
            } else {
                // slug.siteadi.com veya slug.localhost deseni: doğrudan ilk parça slug veya ana_domain kontrolü
                // Önce slug ile dene
                $kayit = DB::table('kurumlar')->where('slug', $sub)->where('aktif_mi', true)->first();
                if ($kayit) {
                    $kurumId = $kayit->id;
                    $kurumSlug = $kayit->slug;
                    $kurumAdi = $kayit->ad;
                } else {
                    // Slug bulunamazsa ana_domain ile dene
                    $kayit = DB::table('kurumlar')->where('ana_domain', $host)->where('aktif_mi', true)->first();
                    if ($kayit) {
                        $kurumId = $kayit->id;
                        $kurumSlug = $kayit->slug;
                        $kurumAdi = $kayit->ad;
                    }
                }
            }
        }

        // Özel domain desteği: tam host eşleşirse çözümle
        if (!$kurumId) {
            $kayit = DB::table('kurumlar')->where('ozel_domain', $host)->where('aktif_mi', true)->first();
            if ($kayit) {
                $kurumId = $kayit->id;
                $kurumSlug = $kayit->slug;
                $kurumAdi = $kayit->ad;
            }
        }

        $request->attributes->set('kurum_id', $kurumId);
        $request->attributes->set('kurum_slug', $kurumSlug);
        $request->attributes->set('kurum_adi', $kurumAdi);
        $request->attributes->set('aktif_domain', $aktifDomain);
        return $next($request);
    }
}
