<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class YoneticiHesaplariController extends Controller
{
    public function index()
    {
        $yoneticiler = DB::table('admin_kullanicilar')
            ->leftJoin('kurumlar', 'admin_kullanicilar.kurum_id', '=', 'kurumlar.id')
            ->select(
                'admin_kullanicilar.*',
                'kurumlar.ad as kurum_ad',
                'kurumlar.slug as kurum_slug',
                DB::raw("CONCAT(admin_kullanicilar.ad, ' ', admin_kullanicilar.soyad) as name")
            )
            ->paginate(15);

        // Kurum verilerini nesneye çevir
        $yoneticiler->getCollection()->transform(function ($yonetici) {
            $yonetici->kurum = (object)[
                'ad' => $yonetici->kurum_ad,
                'slug' => $yonetici->kurum_slug
            ];
            return $yonetici;
        });

        $kurumlar = DB::table('kurumlar')->get();

        return view('superadmin.yoneticiler.index', compact('yoneticiler', 'kurumlar'));
    }

    public function create()
    {
        $kurumlar = DB::table('kurumlar')->get();
        return view('superadmin.yoneticiler.create', compact('kurumlar'));
    }

    public function show($id)
    {
        $yonetici = DB::table('admin_kullanicilar')
            ->leftJoin('kurumlar', 'admin_kullanicilar.kurum_id', '=', 'kurumlar.id')
            ->select(
                'admin_kullanicilar.*',
                'kurumlar.id as kurum_id',
                'kurumlar.ad as kurum_ad',
                'kurumlar.slug as kurum_slug',
                'kurumlar.aktif_mi as kurum_aktif',
                DB::raw("CONCAT(admin_kullanicilar.ad, ' ', admin_kullanicilar.soyad) as name")
            )
            ->where('admin_kullanicilar.id', $id)
            ->first();

        if (!$yonetici) {
            return redirect()->route('superadmin.yoneticiler.index')
                ->with('error', 'Yönetici bulunamadı.');
        }

        // Kurum nesnesini oluştur
        $yonetici->kurum = (object)[
            'id' => $yonetici->kurum_id,
            'ad' => $yonetici->kurum_ad,
            'slug' => $yonetici->kurum_slug,
            'aktif_mi' => $yonetici->kurum_aktif,
            'kullanicilar_count' => DB::table('kullanicilar')->where('kurum_id', $yonetici->kurum_id)->count(),
            'kan_ilanlari_count' => DB::table('kan_ilanlari')->where('kurum_id', $yonetici->kurum_id)->count(),
        ];

        return view('superadmin.yoneticiler.show', compact('yonetici'));
    }

    public function edit($id)
    {
        $yonetici = DB::table('admin_kullanicilar')->where('id', $id)->first();
        
        if (!$yonetici) {
            return redirect()->route('superadmin.yoneticiler.index')
                ->with('error', 'Yönetici bulunamadı.');
        }

        $kurumlar = DB::table('kurumlar')->get();
        return view('superadmin.yoneticiler.edit', compact('yonetici', 'kurumlar'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'ad' => 'required|string|max:255',
            'soyad' => 'required|string|max:255',
            'kullanici_adi' => 'required|string|max:255|unique:admin_kullanicilar,kullanici_adi',
            'email' => 'required|string|email|max:255|unique:admin_kullanicilar',
            'password' => 'required|string|min:8|confirmed',
            'kurum_id' => 'required|exists:kurumlar,id',
        ]);

        DB::table('admin_kullanicilar')->insert([
            'ad' => $request->ad,
            'soyad' => $request->soyad,
            'kullanici_adi' => $request->kullanici_adi,
            'email' => $request->email,
            'password' => bcrypt($request->password),
            'kurum_id' => $request->kurum_id,
            'rol' => 'admin',
            'aktif' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('superadmin.yoneticiler.index')->with('success', 'Kurum yöneticisi başarıyla oluşturuldu.');
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'ad' => 'required|string|max:255',
            'soyad' => 'required|string|max:255',
            'kullanici_adi' => 'required|string|max:255|unique:admin_kullanicilar,kullanici_adi,' . $id,
            'email' => 'required|string|email|max:255|unique:admin_kullanicilar,email,' . $id,
            'password' => 'nullable|string|min:8|confirmed',
            'kurum_id' => 'required|exists:kurumlar,id',
        ]);

        $data = [
            'ad' => $request->ad,
            'soyad' => $request->soyad,
            'kullanici_adi' => $request->kullanici_adi,
            'email' => $request->email,
            'kurum_id' => $request->kurum_id,
            'updated_at' => now(),
        ];

        if ($request->filled('password')) {
            $data['password'] = bcrypt($request->password);
        }

        DB::table('admin_kullanicilar')->where('id', $id)->update($data);

        return redirect()->route('superadmin.yoneticiler.show', $id)->with('success', 'Kurum yöneticisi başarıyla güncellendi.');
    }

    public function destroy($id)
    {
        DB::table('admin_kullanicilar')->where('id', $id)->delete();
        return redirect()->route('superadmin.yoneticiler.index')->with('success', 'Kurum yöneticisi başarıyla silindi.');
    }
}
