<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TahsilatController extends Controller
{
    public function index()
    {
        $tahsilatlar = DB::table('kurum_tahsilatlar')->orderByDesc('tahsilat_tarihi')->paginate(20);
        return view('superadmin.tahsilat.index', compact('tahsilatlar'));
    }

    public function create()
    {
        $kurumlar = DB::table('kurumlar')->orderBy('ad')->get();
        $tahakkuklar = DB::table('kurum_tahakkuklar')->orderByDesc('created_at')->get();
        return view('superadmin.tahsilat.create', compact('kurumlar','tahakkuklar'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'kurum_id' => 'required|exists:kurumlar,id',
            'tahakkuk_id' => 'required|exists:kurum_tahakkuklar,id',
            'tutar' => 'required|numeric|min:0.01',
            'tahsilat_tarihi' => 'required|date',
            'yontem' => 'nullable|string|max:100',
            'aciklama' => 'nullable|string|max:255',
        ]);
        DB::table('kurum_tahsilatlar')->insert(array_merge($data, [
            'created_at' => now(), 'updated_at' => now()
        ]));
        return redirect()->route('superadmin.tahsilat.index')->with('ok','Tahsilat eklendi');
    }

    public function show($id)
    {
        $ts = DB::table('kurum_tahsilatlar')->where('id', $id)->first();
        abort_unless($ts, 404);
        
        $kurum = DB::table('kurumlar')->where('id', $ts->kurum_id)->first();
        $tahakkuk = DB::table('kurum_tahakkuklar')->where('id', $ts->tahakkuk_id)->first();
        
        return view('superadmin.tahsilat.show', compact('ts', 'kurum', 'tahakkuk'));
    }

    public function edit($id)
    {
        $ts = DB::table('kurum_tahsilatlar')->where('id', $id)->first();
        abort_unless($ts, 404);
        $kurumlar = DB::table('kurumlar')->orderBy('ad')->get();
        $tahakkuklar = DB::table('kurum_tahakkuklar')->orderByDesc('created_at')->get();
        return view('superadmin.tahsilat.edit', compact('ts','kurumlar','tahakkuklar'));
    }

    public function update(Request $request, $id)
    {
        $ts = DB::table('kurum_tahsilatlar')->where('id', $id)->first();
        abort_unless($ts, 404);
        $data = $request->validate([
            'kurum_id' => 'required|exists:kurumlar,id',
            'tahakkuk_id' => 'required|exists:kurum_tahakkuklar,id',
            'tutar' => 'required|numeric|min:0.01',
            'tahsilat_tarihi' => 'required|date',
            'yontem' => 'nullable|string|max:100',
            'aciklama' => 'nullable|string|max:255',
        ]);
        DB::table('kurum_tahsilatlar')->where('id', $id)->update(array_merge($data, [
            'updated_at' => now()
        ]));
        return redirect()->route('superadmin.tahsilat.index')->with('ok','Tahsilat güncellendi');
    }

    public function destroy($id)
    {
        DB::table('kurum_tahsilatlar')->where('id', $id)->delete();
        return redirect()->route('superadmin.tahsilat.index')->with('ok','Tahsilat silindi');
    }
}
