<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TahakkukController extends Controller
{
    public function index()
    {
        $tahakkuklar = DB::table('kurum_tahakkuklar')->orderByDesc('created_at')->paginate(20);
        return view('superadmin.tahakkuk.index', compact('tahakkuklar'));
    }

    public function create()
    {
        $kurumlar = DB::table('kurumlar')->orderBy('ad')->get();
        return view('superadmin.tahakkuk.create', compact('kurumlar'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'kurum_id' => 'required|exists:kurumlar,id',
            'baslik' => 'required|string|max:255',
            'aciklama' => 'nullable|string',
            'tutar' => 'required|numeric|min:0',
            'vade_tarihi' => 'nullable|date',
            'aktif_mi' => 'nullable|boolean',
        ]);
        $data['aktif_mi'] = $data['aktif_mi'] ?? true;
        DB::table('kurum_tahakkuklar')->insert(array_merge($data, [
            'created_at' => now(), 'updated_at' => now()
        ]));
        return redirect()->route('superadmin.tahakkuk.index')->with('ok','Tahakkuk eklendi');
    }

    public function show($id)
    {
        $t = DB::table('kurum_tahakkuklar')->where('id', $id)->first();
        abort_unless($t, 404);
        
        $kurum = DB::table('kurumlar')->where('id', $t->kurum_id)->first();
        $tahsilatlar = DB::table('kurum_tahsilatlar')->where('tahakkuk_id', $id)->get();
        $toplamOdeme = $tahsilatlar->sum('tutar');
        $kalanBorc = $t->tutar - $toplamOdeme;
        
        return view('superadmin.tahakkuk.show', compact('t', 'kurum', 'tahsilatlar', 'toplamOdeme', 'kalanBorc'));
    }

    public function edit($id)
    {
        $t = DB::table('kurum_tahakkuklar')->where('id', $id)->first();
        abort_unless($t, 404);
        $kurumlar = DB::table('kurumlar')->orderBy('ad')->get();
        return view('superadmin.tahakkuk.edit', compact('t','kurumlar'));
    }

    public function update(Request $request, $id)
    {
        $t = DB::table('kurum_tahakkuklar')->where('id', $id)->first();
        abort_unless($t, 404);
        $data = $request->validate([
            'kurum_id' => 'required|exists:kurumlar,id',
            'baslik' => 'required|string|max:255',
            'aciklama' => 'nullable|string',
            'tutar' => 'required|numeric|min:0',
            'vade_tarihi' => 'nullable|date',
            'aktif_mi' => 'nullable|boolean',
        ]);
        $data['aktif_mi'] = $data['aktif_mi'] ?? $t->aktif_mi;
        DB::table('kurum_tahakkuklar')->where('id', $id)->update(array_merge($data, [
            'updated_at' => now()
        ]));
        return redirect()->route('superadmin.tahakkuk.index')->with('ok','Tahakkuk güncellendi');
    }

    public function destroy($id)
    {
        // Tahsilatı varsa silinemez
        $odemeVarMi = DB::table('kurum_tahsilatlar')->where('tahakkuk_id', $id)->exists();
        if ($odemeVarMi) {
            return redirect()->route('superadmin.tahakkuk.index')->with('ok','Tahsilatı olan tahakkuk silinemez');
        }
        DB::table('kurum_tahakkuklar')->where('id', $id)->delete();
        return redirect()->route('superadmin.tahakkuk.index')->with('ok','Tahakkuk silindi');
    }
}
