<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;

class SistemBakimController extends Controller
{
    public function index()
    {
        $logPath = storage_path('logs/laravel.log');
        $logSize = File::exists($logPath) ? File::size($logPath) : 0;
        $logSizeMB = number_format($logSize / 1048576, 2);
        
        $cacheSize = $this->getFolderSize(storage_path('framework/cache'));
        $cacheSizeMB = number_format($cacheSize / 1048576, 2);
        
        $viewCacheSize = $this->getFolderSize(storage_path('framework/views'));
        $viewCacheSizeMB = number_format($viewCacheSize / 1048576, 2);
        
        return view('superadmin.sistem-bakim.index', compact('logSizeMB', 'cacheSizeMB', 'viewCacheSizeMB'));
    }
    
    public function clearCache()
    {
        try {
            Artisan::call('cache:clear');
            Artisan::call('config:clear');
            Artisan::call('route:clear');
            Artisan::call('view:clear');
            
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('success', 'Önbellek başarıyla temizlendi.');
        } catch (\Exception $e) {
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('error', 'Önbellek temizlenirken hata oluştu: ' . $e->getMessage());
        }
    }
    
    public function clearLogs()
    {
        try {
            $logPath = storage_path('logs/laravel.log');
            if (File::exists($logPath)) {
                File::put($logPath, '');
                Log::info('Log dosyası temizlendi - ' . now());
            }
            
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('success', 'Log dosyası başarıyla temizlendi.');
        } catch (\Exception $e) {
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('error', 'Log dosyası temizlenirken hata oluştu: ' . $e->getMessage());
        }
    }
    
    public function viewLogs()
    {
        $logPath = storage_path('logs/laravel.log');
        $logs = '';
        
        if (File::exists($logPath)) {
            $logs = File::get($logPath);
            // Son 10000 karakteri al (çok büyük olursa sayfa yüklenemez)
            $logs = substr($logs, -50000);
        }
        
        return view('superadmin.sistem-bakim.logs', compact('logs'));
    }
    
    public function optimizeSystem()
    {
        try {
            Artisan::call('optimize:clear');
            Artisan::call('optimize');
            
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('success', 'Sistem başarıyla optimize edildi.');
        } catch (\Exception $e) {
            return redirect()->route('superadmin.sistem-bakim.index')
                ->with('error', 'Sistem optimize edilirken hata oluştu: ' . $e->getMessage());
        }
    }
    
    private function getFolderSize($path)
    {
        $size = 0;
        if (File::isDirectory($path)) {
            foreach (File::allFiles($path) as $file) {
                $size += $file->getSize();
            }
        }
        return $size;
    }
}
