<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class KurumlarController extends Controller
{
    public function index()
    {
        $kurumlar = DB::table('kurumlar')->orderBy('ad')->paginate(20);
        return view('superadmin.kurumlar.index', compact('kurumlar'));
    }

    public function create()
    {
        return view('superadmin.kurumlar.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'ad' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:kurumlar,slug',
            'ana_domain' => 'nullable|string|max:255',
            'ozel_domain' => 'nullable|string|max:255|unique:kurumlar,ozel_domain',
            'site_ana_domain' => 'nullable|string|max:255',
            'subdomain_tipi' => 'required|in:slug,kan',
            'aktif_mi' => 'nullable|boolean',
        ]);
        $data['aktif_mi'] = $data['aktif_mi'] ?? true;
        DB::table('kurumlar')->insert(array_merge($data, [
            'created_at' => now(), 'updated_at' => now()
        ]));
        return redirect()->route('superadmin.kurumlar.index')->with('ok','Kurum eklendi');
    }

    public function show($kurumId)
    {
        $kurum = DB::table('kurumlar')->where('id', $kurumId)->first();
        abort_unless($kurum, 404);
        
        // İstatistikler
        $stats = [
            'yoneticiler_count' => DB::table('users')->where('kurum_id', $kurumId)->count(),
            'kullanicilar_count' => DB::table('kullanicilar')->where('kurum_id', $kurumId)->count(),
            'kan_ilanlari_count' => DB::table('kan_ilanlari')->where('kurum_id', $kurumId)->count(),
        ];
        
        return view('superadmin.kurumlar.show', compact('kurum', 'stats'));
    }

    public function edit($kurumId)
    {
        $kurum = DB::table('kurumlar')->where('id', $kurumId)->first();
        abort_unless($kurum, 404);
        return view('superadmin.kurumlar.edit', compact('kurum'));
    }

    public function update(Request $request, $kurumId)
    {
        $kurum = DB::table('kurumlar')->where('id', $kurumId)->first();
        abort_unless($kurum, 404);
        $data = $request->validate([
            'ad' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:kurumlar,slug,'.$kurumId,
            'ana_domain' => 'nullable|string|max:255',
            'ozel_domain' => 'nullable|string|max:255|unique:kurumlar,ozel_domain,'.$kurumId,
            'site_ana_domain' => 'nullable|string|max:255',
            'subdomain_tipi' => 'required|in:slug,kan',
            'aktif_mi' => 'nullable|boolean',
        ]);
        $data['aktif_mi'] = $data['aktif_mi'] ?? $kurum->aktif_mi;
        DB::table('kurumlar')->where('id', $kurumId)->update(array_merge($data, [
            'updated_at' => now()
        ]));
        return redirect()->route('superadmin.kurumlar.index')->with('ok','Kurum güncellendi');
    }

    public function destroy($kurumId)
    {
        DB::table('kurumlar')->where('id', $kurumId)->delete();
        return redirect()->route('superadmin.kurumlar.index')->with('ok','Kurum silindi');
    }
}
