<?php

namespace App\Http\Controllers\Superadmin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OturumController extends Controller
{
    public function showLoginForm()
    {
        return view('superadmin.auth.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'kullanici_adi' => ['required', 'string'],
            'password' => ['required'],
        ]);

        $credentials = [
            'kullanici_adi' => $request->kullanici_adi,
            'password' => $request->password,
        ];

        if (Auth::guard('superadmin')->attempt($credentials, $request->boolean('remember'))) {
            $request->session()->regenerate();
            return redirect()->intended(route('superadmin.anasayfa'));
        }

        return back()->withErrors([
            'kullanici_adi' => 'Girilen bilgilerle eşleşen bir kullanıcı bulunamadı.',
        ])->onlyInput('kullanici_adi');
    }

    public function logout(Request $request)
    {
        Auth::guard('superadmin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('superadmin.giris');
    }
}
