<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PublicController extends Controller
{
    /**
     * Herkese açık ilan detay sayfasını gösterir.
     * Rota model binding ile KanIlani modeli beklenir, ancak veritabanı tablosu kullandığımız için ID alıp sorgu yapacağız.
     *
     * @param Request $request
     * @param int $ilanId
     * @return \Illuminate\Contracts\View\View
     */
    public function showIlan(Request $request, $ilanId)
    {
        $ilan = DB::table('kan_ilanlari')->find($ilanId);

        if (!$ilan) {
            abort(404, 'İlan bulunamadı.');
        }

        // İlanın kurumunu bul
        $kurum = DB::table('kurumlar')->find($ilan->kurum_id);

        // İlan sahibinin adını ve soyadını al (gizlilik için sadece baş harfleri de gösterilebilir)
        $ilanSahibi = DB::table('kullanicilar')->find($ilan->kullanici_id);

        return view('public.ilan-detay', compact('ilan', 'kurum', 'ilanSahibi'));
    }
}
