<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class IlanLinkController extends Controller
{
    /**
     * Token ile kan ilan detayını gösterir
     * 72 saat geçerlilik kontrolü yapar
     */
    public function show($token)
    {
        // Token ile ilan bul (case sensitive) - admin paneldeki gibi tam detaylı
        $ilan = DB::table('kan_ilanlari')
            ->leftJoin('kan_gruplari', 'kan_ilanlari.kan_grubu_id', '=', 'kan_gruplari.id')
            ->leftJoin('kullanicilar', 'kan_ilanlari.kullanici_id', '=', 'kullanicilar.id')
            ->leftJoin('iller as hastane_iller', 'kan_ilanlari.il_id', '=', 'hastane_iller.id')
            ->leftJoin('kurum_iller as hastane_kurum_iller', 'kan_ilanlari.il_id', '=', 'hastane_kurum_iller.id')
            ->leftJoin('ilceler as hastane_ilceler', 'kan_ilanlari.ilce_id', '=', 'hastane_ilceler.id')
            ->leftJoin('kurum_ilceler as hastane_kurum_ilceler', 'kan_ilanlari.ilce_id', '=', 'hastane_kurum_ilceler.id')
            ->leftJoin('iller as kullanici_iller', 'kullanicilar.il_id', '=', 'kullanici_iller.id')
            ->leftJoin('kurum_iller as kullanici_kurum_iller', 'kullanicilar.il_id', '=', 'kullanici_kurum_iller.id')
            ->leftJoin('ilceler as kullanici_ilceler', 'kullanicilar.ilce_id', '=', 'kullanici_ilceler.id')
            ->leftJoin('kurum_ilceler as kullanici_kurum_ilceler', 'kullanicilar.ilce_id', '=', 'kullanici_kurum_ilceler.id')
            ->leftJoin('kurumlar', 'kan_ilanlari.kurum_id', '=', 'kurumlar.id')
            ->select(
                'kan_ilanlari.*',
                'kan_gruplari.ad as kan_grubu_adi',
                'kullanicilar.ad as kullanici_adi',
                'kullanicilar.soyad as kullanici_soyadi',
                'kullanicilar.telefon as kullanici_telefon',
                'kullanicilar.email as kullanici_email',
                'kullanicilar.tc_kimlik as kullanici_tc',
                'kullanicilar.dogum_tarihi as kullanici_dogum_tarihi',
                'kullanicilar.cinsiyet as kullanici_cinsiyet',
                'kullanicilar.sms_izni as kullanici_sms_izni',
                DB::raw('COALESCE(NULLIF(kan_ilanlari.hastane_il, ""), COALESCE(hastane_iller.ad, hastane_kurum_iller.ad)) as hastane_il_adi'),
                DB::raw('COALESCE(NULLIF(kan_ilanlari.hastane_ilce, ""), COALESCE(hastane_ilceler.ad, hastane_kurum_ilceler.ad)) as hastane_ilce_adi'),
                DB::raw('COALESCE(kullanici_iller.ad, kullanici_kurum_iller.ad) as kullanici_il_adi'),
                DB::raw('COALESCE(kullanici_ilceler.ad, kullanici_kurum_ilceler.ad) as kullanici_ilce_adi'),
                'kurumlar.ad as kurum_adi'
            )
            ->whereRaw('BINARY kan_ilanlari.link_token = ?', [$token])
            ->first();

        if (!$ilan) {
            abort(404, 'İlan bulunamadı.');
        }

        // Geçerlilik tarihi kontrolü (72 saat)
        if ($ilan->link_gecerlilik_tarihi && Carbon::parse($ilan->link_gecerlilik_tarihi)->isPast()) {
            return view('public.ilan-suresi-dolmus');
        }

        // Veriyi düzenle (view için uygun formata getir)
        $kanGrubu = (object)['ad' => $ilan->kan_grubu_adi];
        $hastaneIl = (object)['ad' => $ilan->hastane_il_adi];
        $hastaneIlce = (object)['ad' => $ilan->hastane_ilce_adi];
        $kullaniciIl = (object)['ad' => $ilan->kullanici_il_adi];
        $kullaniciIlce = (object)['ad' => $ilan->kullanici_ilce_adi];
        $kurum = (object)['ad' => $ilan->kurum_adi];
        $kullanici = (object)[
            'ad' => $ilan->kullanici_adi,
            'soyad' => $ilan->kullanici_soyadi,
            'telefon' => $ilan->kullanici_telefon,
            'email' => $ilan->kullanici_email,
            'tc_kimlik' => $ilan->kullanici_tc,
            'dogum_tarihi' => $ilan->kullanici_dogum_tarihi,
            'cinsiyet' => $ilan->kullanici_cinsiyet,
            'sms_izni' => $ilan->kullanici_sms_izni
        ];

        return view('public.ilan-detay', compact('ilan', 'kanGrubu', 'hastaneIl', 'hastaneIlce', 'kullaniciIl', 'kullaniciIlce', 'kurum', 'kullanici'));
    }
}
