<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Abort;

class IlanDetayController extends Controller
{
    public function goster(Request $request, int $ilanId)
    {
        $kod = $request->query('k');
        if (!$kod) {
            abort(403, 'Erişim kodu gerekli');
        }
        $kayit = DB::table('ilan_erisim_kodlari')
            ->where('kan_ilan_id', $ilanId)
            ->where('erisim_kodu', $kod)
            ->where(function($q){ $q->whereNull('son_kullanim_tarihi')->orWhere('son_kullanim_tarihi','>=',now()); })
            ->first();
        if (!$kayit) {
            abort(403, 'Erişim kodu geçersiz veya süresi dolmuş');
        }
        $ilan = DB::table('kan_ilanlari')->where('id', $ilanId)->first();
        if (!$ilan) {
            abort(404);
        }
        return view('pages.ilan_detay', ['ilan' => $ilan]);
    }
}
