<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SmsYonetimiController extends Controller
{
    // SMS Ayarları Sayfası
    public function ayarlar(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        $ayarlar = DB::table('kurum_sms_ayarlari')->where('kurum_id', $kurumId)->first();

        return view('admin.sms-yonetimi.ayarlar', compact('ayarlar'));
    }

    // SMS Şablonlar Sayfası
    public function sablonlar(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        $sablonlar = DB::table('sms_sablonlari')->where('kurum_id', $kurumId)->get();

        return view('admin.sms-yonetimi.sablonlar', compact('sablonlar'));
    }

    public function saveApiSettings(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        $request->validate([
            'servis_saglayici' => 'required|in:netgsm,jetsms',
            'api_key' => 'required|string',
            'api_secret' => 'required|string',
            'api_header' => 'required|string',
        ]);

        DB::table('kurum_sms_ayarlari')->updateOrInsert(
            ['kurum_id' => $kurumId],
            [
                'servis_saglayici' => $request->servis_saglayici,
                'api_key' => $request->api_key,
                'api_secret' => $request->api_secret,
                'api_header' => $request->api_header,
                'aktif' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        return back()->with('success', 'SMS API ayarları başarıyla kaydedildi.');
    }

    public function deleteTemplate(Request $request, $id)
    {
        $kurumId = $request->attributes->get('kurum_id');
        
        DB::table('sms_sablonlari')
            ->where('id', $id)
            ->where('kurum_id', $kurumId)
            ->delete();

        return back()->with('success', 'SMS şablonu başarıyla silindi.');
    }

    public function raporlar(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        
        // SMS istatistikleri
        $bugun = DB::table('sms_kayitlari')
            ->where('kurum_id', $kurumId)
            ->whereDate('created_at', today())
            ->count();

        $buAy = DB::table('sms_kayitlari')
            ->where('kurum_id', $kurumId)
            ->whereMonth('created_at', now()->month)
            ->whereYear('created_at', now()->year)
            ->count();

        $toplam = DB::table('sms_kayitlari')
            ->where('kurum_id', $kurumId)
            ->count();

        // Son gönderilen SMS'ler (olusturulma_tarihi varsa onu kullan)
        $sonSmsler = DB::table('sms_kayitlari')
            ->where('kurum_id', $kurumId)
            ->orderByRaw('COALESCE(olusturulma_tarihi, created_at) DESC')
            ->limit(50)
            ->get();

        return view('admin.sms-yonetimi.raporlar', compact('bugun', 'buAy', 'toplam', 'sonSmsler'));
    }

    public function saveTemplate(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        $request->validate([
            'baslik' => 'required|string|max:255',
            'icerik' => 'required|string',
            'tur' => 'required|string',
        ]);

        DB::table('sms_sablonlari')->updateOrInsert(
            ['kurum_id' => $kurumId, 'tur' => $request->tur],
            [
                'baslik' => $request->baslik,
                'icerik' => $request->icerik,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );

        return back()->with('success', 'SMS şablonu başarıyla kaydedildi.');
    }

    public function testSms(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        
        $request->validate([
            'telefon' => 'required|string|size:10|regex:/^5[0-9]{9}$/'
        ]);

        $telefon = $request->telefon;

        // SMS ayarlarını al
        $ayarlar = DB::table('kurum_sms_ayarlari')->where('kurum_id', $kurumId)->first();

        if (!$ayarlar || !$ayarlar->servis_saglayici) {
            return response()->json([
                'success' => false,
                'message' => 'SMS ayarları yapılandırılmamış. Lütfen önce API ayarlarını kaydedin.'
            ], 400);
        }

        try {
            // Seçilen operatöre göre dinamik provider
            $apiAyarlari = [
                'username' => $ayarlar->api_key,
                'password' => $ayarlar->api_secret,
            ];
            $baslik = $ayarlar->api_header;

            $mesaj = "Test SMS: SMS servisiniz başarıyla çalışıyor! - " . config('app.name');
            
            $saglayici = \App\Services\Sms\SmsFactory::create($ayarlar->servis_saglayici);
            $sonuc = $saglayici->gonder($apiAyarlari, $baslik, $mesaj, [$telefon]);

            if ($sonuc['status'] === 'success') {
                // SMS kaydını veritabanına kaydet
                DB::table('sms_kayitlari')->insert([
                    'kurum_id' => $kurumId,
                    'tip' => 'Test SMS',
                    'telefon' => $telefon,
                    'mesaj' => $mesaj,
                    'hedef_numara_sayisi' => 1,
                    'durum' => 'success',
                    'sms_saglayici_mesaj_id' => $sonuc['data']['message_id'] ?? null,
                    'olusturulma_tarihi' => now(),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                return response()->json([
                    'success' => true,
                    'message' => 'Test SMS başarıyla gönderildi! (' . $telefon . ')'
                ]);
            } else {
                // Hata kaydı
                DB::table('sms_kayitlari')->insert([
                    'kurum_id' => $kurumId,
                    'tip' => 'Test SMS',
                    'telefon' => $telefon,
                    'mesaj' => $mesaj,
                    'hedef_numara_sayisi' => 1,
                    'durum' => 'error',
                    'hata_mesaji' => $sonuc['message'] ?? 'Bilinmeyen hata',
                    'olusturulma_tarihi' => now(),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                return response()->json([
                    'success' => false,
                    'message' => 'SMS gönderilemedi: ' . ($sonuc['message'] ?? 'Bilinmeyen hata')
                ], 500);
            }
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Hata: ' . $e->getMessage()
            ], 500);
        }
    }
}
