<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RaporController extends Controller
{
    public function index(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');

        // Temel Raporlar
        $toplamKullanici = DB::table('kullanicilar')->where('kurum_id', $kurumId)->count();
        $toplamIlan = DB::table('kan_ilanlari')->where('kurum_id', $kurumId)->count();
        $toplamGonderilenSms = DB::table('sms_kayitlari')->where('kurum_id', $kurumId)->sum('hedef_numara_sayisi');

        // Kan Grubuna Göre Kullanıcı Dağılımı
        $kanGrubuDagilimi = DB::table('kullanicilar')
            ->leftJoin('kan_gruplari', 'kullanicilar.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kullanicilar.kurum_id', $kurumId)
            ->select('kan_gruplari.ad as kan_grubu', DB::raw('count(*) as total'))
            ->groupBy('kan_gruplari.ad')
            ->orderBy('total', 'desc')
            ->get();

        // Son 10 Kan İlanı
        $sonIlanlar = DB::table('kan_ilanlari')
            ->where('kurum_id', $kurumId)
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();


        return view('admin.raporlar.index', compact(
            'toplamKullanici',
            'toplamIlan',
            'toplamGonderilenSms',
            'kanGrubuDagilimi',
            'sonIlanlar'
        ));
    }

    public function kullaniciBazliIlanlar(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');

        $kullanicilar = DB::table('kullanicilar')
            ->leftJoin('kan_ilanlari', 'kullanicilar.id', '=', 'kan_ilanlari.kullanici_id')
            ->leftJoin('kan_gruplari', 'kullanicilar.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kullanicilar.kurum_id', $kurumId)
            ->select(
                'kullanicilar.id',
                'kullanicilar.ad',
                'kullanicilar.soyad',
                'kullanicilar.email',
                'kullanicilar.telefon',
                'kan_gruplari.ad as kan_grubu',
                DB::raw('COUNT(kan_ilanlari.id) as ilan_sayisi')
            )
            ->groupBy('kullanicilar.id', 'kullanicilar.ad', 'kullanicilar.soyad', 'kullanicilar.email', 'kullanicilar.telefon', 'kan_gruplari.ad')
            ->orderBy('ilan_sayisi', 'desc')
            ->get();

        return view('admin.raporlar.kullanici-bazli-ilanlar', compact('kullanicilar'));
    }

    public function kanGrubuKullanicilar(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');

        $kanGruplari = DB::table('kullanicilar')
            ->leftJoin('kan_gruplari', 'kullanicilar.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kullanicilar.kurum_id', $kurumId)
            ->select(
                'kan_gruplari.ad as kan_grubu',
                DB::raw('COUNT(*) as kullanici_sayisi'),
                DB::raw('COUNT(CASE WHEN kullanicilar.aktif = 1 THEN 1 END) as aktif_sayisi'),
                DB::raw('COUNT(CASE WHEN kullanicilar.sms_izni = 1 THEN 1 END) as sms_izinli_sayisi')
            )
            ->groupBy('kan_gruplari.ad')
            ->orderBy('kullanici_sayisi', 'desc')
            ->get();

        $toplamKullanici = $kanGruplari->sum('kullanici_sayisi');

        return view('admin.raporlar.kan-grubu-kullanicilar', compact('kanGruplari', 'toplamKullanici'));
    }

    public function kanGrubuIlanlari(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');

        $kanGrubuIlanlar = DB::table('kan_ilanlari')
            ->leftJoin('kan_gruplari', 'kan_ilanlari.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kan_ilanlari.kurum_id', $kurumId)
            ->select(
                'kan_gruplari.ad as kan_grubu',
                DB::raw('COUNT(*) as ilan_sayisi'),
                DB::raw('COUNT(CASE WHEN kan_ilanlari.durum = "aktif" THEN 1 END) as aktif_ilan'),
                DB::raw('COUNT(CASE WHEN kan_ilanlari.durum = "tamamlandi" THEN 1 END) as tamamlanan_ilan'),
                DB::raw('COUNT(CASE WHEN kan_ilanlari.durum = "iptal" THEN 1 END) as iptal_ilan')
            )
            ->groupBy('kan_gruplari.ad')
            ->orderBy('ilan_sayisi', 'desc')
            ->get();

        $toplamIlan = $kanGrubuIlanlar->sum('ilan_sayisi');
        $kanGruplari = $kanGrubuIlanlar;

        return view('admin.raporlar.kan-grubu-ilanlari', compact('kanGruplari', 'toplamIlan'));
    }

    public function kanGrubuDetay(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        $kanGrubu = $request->query('kan_grubu');

        $kanGruplari = DB::table('kullanicilar')
            ->where('kurum_id', $kurumId)
            ->select('kan_grubu')
            ->distinct()
            ->orderBy('kan_grubu')
            ->pluck('kan_grubu');

        $kullanicilar = null;
        if ($kanGrubu) {
            $kullanicilar = DB::table('kullanicilar')
                ->leftJoin('iller', 'kullanicilar.il_id', '=', 'iller.id')
                ->leftJoin('ilceler', 'kullanicilar.ilce_id', '=', 'ilceler.id')
                ->where('kullanicilar.kurum_id', $kurumId)
                ->where('kullanicilar.kan_grubu', $kanGrubu)
                ->select(
                    'kullanicilar.id',
                    'kullanicilar.ad',
                    'kullanicilar.soyad',
                    'kullanicilar.email',
                    'kullanicilar.telefon',
                    'kullanicilar.aktif',
                    'kullanicilar.sms_izni',
                    'kullanicilar.created_at',
                    'iller.ad as il_ad',
                    'ilceler.ad as ilce_ad'
                )
                ->orderBy('kullanicilar.ad')
                ->get();
        }

        return view('admin.raporlar.kan-grubu-detay', compact('kanGruplari', 'kullanicilar', 'kanGrubu'));
    }
}
