<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class ProfilController extends Controller
{
    public function index()
    {
        $user = Auth::guard('admin')->user();
        
        return view('admin.profil.index', compact('user'));
    }

    public function update(Request $request)
    {
        $user = Auth::guard('admin')->user();

        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:admin_kullanicilar,email,' . $user->id],
            'current_password' => ['nullable', 'required_with:password'],
            'password' => ['nullable', 'confirmed', Password::defaults()],
        ], [
            'name.required' => 'Ad soyad zorunludur.',
            'email.required' => 'E-posta adresi zorunludur.',
            'email.email' => 'Geçerli bir e-posta adresi giriniz.',
            'email.unique' => 'Bu e-posta adresi başka bir kullanıcı tarafından kullanılıyor.',
            'current_password.required_with' => 'Yeni şifre belirlemek için mevcut şifrenizi girmelisiniz.',
            'password.confirmed' => 'Şifre tekrarı eşleşmiyor.',
        ]);

        // Mevcut şifre kontrolü (eğer yeni şifre girilmişse)
        if ($request->filled('password')) {
            if (!Hash::check($request->current_password, $user->password)) {
                return back()->withErrors(['current_password' => 'Mevcut şifreniz yanlış.'])->withInput();
            }
        }

        // Ad Soyad ayrıştırma
        $nameParts = explode(' ', $validated['name'], 2);
        $user->ad = $nameParts[0];
        $user->soyad = $nameParts[1] ?? '';
        $user->email = $validated['email'];

        // Şifre değiştirilecekse
        if ($request->filled('password')) {
            $user->password = Hash::make($validated['password']);
        }

        $user->save();

        return back()->with('success', 'Profil bilgileriniz başarıyla güncellendi.');
    }
}
