<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $kurumId = $request->attributes->get('kurum_id');
        
        // İstatistikler
        $stats = [
            'toplam_kullanici' => DB::table('kullanicilar')->where('kurum_id', $kurumId)->count(),
            'aktif_kullanici' => DB::table('kullanicilar')->where('kurum_id', $kurumId)->where('aktif', true)->count(),
            'toplam_ilan' => DB::table('kan_ilanlari')->where('kurum_id', $kurumId)->count(),
            'aktif_ilan' => DB::table('kan_ilanlari')->where('kurum_id', $kurumId)->where('durum', 'aktif')->count(),
            'bugun_ilan' => DB::table('kan_ilanlari')
                ->where('kurum_id', $kurumId)
                ->whereDate('created_at', Carbon::today())
                ->count(),
            'toplam_sms' => DB::table('sms_kayitlari')->where('kurum_id', $kurumId)->count(),
            'bu_ay_sms' => DB::table('sms_kayitlari')
                ->where('kurum_id', $kurumId)
                ->whereMonth('created_at', Carbon::now()->month)
                ->whereYear('created_at', Carbon::now()->year)
                ->count(),
        ];

        // Bugünkü ilanlar
        $bugunIlanlar = DB::table('kan_ilanlari')
            ->leftJoin('kullanicilar', 'kan_ilanlari.kullanici_id', '=', 'kullanicilar.id')
            ->leftJoin('kan_gruplari', 'kan_ilanlari.kan_grubu_id', '=', 'kan_gruplari.id')
            ->leftJoin('iller', 'kan_ilanlari.il_id', '=', 'iller.id')
            ->where('kan_ilanlari.kurum_id', $kurumId)
            ->whereDate('kan_ilanlari.created_at', Carbon::today())
            ->select(
                'kan_ilanlari.*',
                'kullanicilar.ad as kullanici_ad',
                'kullanicilar.soyad as kullanici_soyad',
                'kan_gruplari.ad as kan_grubu',
                'iller.ad as il_adi'
            )
            ->orderBy('kan_ilanlari.created_at', 'desc')
            ->limit(10)
            ->get();

        // Son ilanlar
        $sonIlanlar = DB::table('kan_ilanlari')
            ->leftJoin('kullanicilar', 'kan_ilanlari.kullanici_id', '=', 'kullanicilar.id')
            ->leftJoin('kan_gruplari', 'kan_ilanlari.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kan_ilanlari.kurum_id', $kurumId)
            ->select(
                'kan_ilanlari.*',
                'kullanicilar.ad as kullanici_ad',
                'kullanicilar.soyad as kullanici_soyad',
                'kan_gruplari.ad as kan_grubu'
            )
            ->orderBy('kan_ilanlari.created_at', 'desc')
            ->limit(5)
            ->get();

        // Kan gruplarına göre dağılım
        $kanGrubuDagilim = DB::table('kullanicilar')
            ->leftJoin('kan_gruplari', 'kullanicilar.kan_grubu_id', '=', 'kan_gruplari.id')
            ->where('kullanicilar.kurum_id', $kurumId)
            ->select('kan_gruplari.ad as kan_grubu', DB::raw('count(*) as sayi'))
            ->groupBy('kan_gruplari.ad')
            ->get();

        return view('admin.dashboard', compact('stats', 'bugunIlanlar', 'sonIlanlar', 'kanGrubuDagilim'));
    }
}
