<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateIlanTokens extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ilan:update-tokens';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Tüm ilanlar için yeni 5 karakterlik tokenlar oluşturur';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('İlan tokenları güncelleniyor...');
        
        $ilans = DB::table('kan_ilanlari')->get();
        $bar = $this->output->createProgressBar($ilans->count());
        $bar->start();
        
        foreach ($ilans as $ilan) {
            $tokenData = generate_ilan_link_token($ilan->id);
            DB::table('kan_ilanlari')
                ->where('id', $ilan->id)
                ->update([
                    'link_token' => $tokenData['token'],
                    'link_gecerlilik_tarihi' => $tokenData['gecerlilik_tarihi']
                ]);
            $bar->advance();
        }
        
        $bar->finish();
        $this->newLine();
        $this->info("Toplam {$ilans->count()} ilan güncellendi.");
        
        return 0;
    }
}
